/** \example ahostid.c
 * \brief
 * This is a utility application to compute the hostid
 * of current host based on specified hardware identifiers.
 */
#include "liman.h"

// a valid LIMAN license is not required
#include "usr_liman_lic_mock.c" 

/****************************************************/
int main(int argc, char **argv)
{
 char hostid[LIMPAR_MAX_LEN_HOSTID+1];
 char szVerInfo[256];
 int nErr;
 int nMask=0;

 lim_get_version_info(szVerInfo);
 fprintf(stdout, "ahostid - LIMAN SDK %s\n", szVerInfo);

 nMask |= LIMPAR_MACID;
 nMask |= LIMPAR_HOSTNAME;
 //nMask |= LIMPAR_DISKID;
 if (argc>1) {
   //overwrite with command-line value
   nMask=atoi(argv[1]);
 }

 nErr = lim_get_hostid(hostid,nMask);
 if (nErr != LIM_OK) goto ErrReturn;

 fprintf(stdout,"\n");
 fprintf(stdout,"hostid: %s\n",hostid); 
 fprintf(stdout,"\n");
ErrReturn:
 return 0;
}

