// runme.java
import com.baroks.liman. * ;
public class ex2 implements Runnable
{
	private static String OS = System.getProperty("os.name").toLowerCase();

    static
    {
        /// @brief Load LIMAN SDK dynamic libarary
        try {
			if (OS.contains("win")) {
            	System.loadLibrary("libliman_sdk");
			} else {
				System.loadLibrary("liman_sdk"); //prefix <lib> is implied on non-windows
			}
        }
        catch (Exception e)
        {
            String limanRoot = System.getenv("LIMAN_ROOT");

            if (limanRoot == null) {
                System.out.println("Error: LIMAN_ROOT environment variable is not defined.. ");
            } else {
				try {
					System.load(limanRoot + "/lib/linux64x86/libliman_sdk.so");
				}

				catch (Exception e2) {
					System.load(limanRoot + "/lib/osx64x86/libliman_sdk.jnilib");
				}
		    }
        }
    }

    private static String szLicenseKeyFile;
    private static String szPublicKeyFile;
    private static String szPrivateKeyFile;
    public ex2() { }
    public static void main(final String[] args)
    {
        if (args.length < 3) {
            System.out.println("usage: ex2 licenseKeyFile publicKeyFile privateKeyFile");
            return;
        }
        szLicenseKeyFile = args[0];
        szPublicKeyFile = args[1];
        szPrivateKeyFile = args[2];
        System.out.printf("licenseKeyFile : %s\n", szLicenseKeyFile);
        System.out.printf("publicKeyFile  : %s\n", szPublicKeyFile);
        System.out.printf("privateKeyFile : %s\n", szPrivateKeyFile);
        new ex2().run();
    }
    @Override public void run()
    {
        StringBuffer sbuf = new StringBuffer(255);
        sbuf.setLength(0);
        liman.lim_get_verstr(sbuf);
        System.out.println("version : " + sbuf.toString());
        sbuf.setLength(0);
        liman.lim_get_cpuid(sbuf);
        System.out.println("cpuid   : " + sbuf.toString());
        sbuf.setLength(0);
        liman.lim_get_macid(sbuf, 0);
        System.out.println("macid   : " + sbuf.toString());
        sbuf.setLength(0);
        liman.lim_get_hostid(sbuf, 13);
        System.out.println("hostid  : " + sbuf.toString());
        int [] nMajor = new int [1];
        int [] nMinor = new int [1];
        int [] nRelease = new int [1];
        int [] nRevision = new int [1];
        int [] pnErr = new int [1];
        sbuf.setLength(0);
        liman.lim_get_verkey(nMajor, nMinor, nRelease, nRevision, sbuf);
        System.out.println(sbuf.toString());
        System.out.println("Major     : " + nMajor[0]);
        System.out.println("Minor     : " + nMinor[0]);
        System.out.println("Release   : " + nRelease[0]);
        System.out.println("Revision  : " + nRevision[0]);
        pnErr[0] = liman.LIM_OK;
        SWIGTYPE_p_LIMENV pEnv = liman.lim_create_env(2048, 256, pnErr);
        if (pnErr[0] != liman.LIM_OK)
        {
            sbuf.setLength(0);
            liman.lim_get_errmsg(pEnv, pnErr[0], sbuf);
            System.out.println("Error " + pnErr[0] + ":" + sbuf.toString());
        }
        if (0 > 1)
        {
            System.out.println("Read public key to encrypt message");
            pnErr[0] = liman.lim_read_public_key(pEnv, szPublicKeyFile);
            if (pnErr[0] != liman.LIM_OK) {
                System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
            }
            pnErr[0] = liman.lim_read_private_key(pEnv, szPrivateKeyFile);
            if (pnErr[0] != liman.LIM_OK) {
                System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
            }
            if (1 > 2)
            {
                StringBuffer sbuf1 = new StringBuffer(liman.LIMPAR_MAX_LIC_STRING_LEN);
                StringBuffer sbuf2 = new StringBuffer(liman.LIMPAR_MAX_LIC_STRING_LEN);
                StringBuffer sbuf3 = new StringBuffer(liman.LIMPAR_MAX_LIC_STRING_LEN);
                sbuf1.setLength(0);
                sbuf2.setLength(0);
                sbuf2.setLength(0);
                liman.lim_get_keypair(pEnv, sbuf1, sbuf2, sbuf3);
                System.out.println("P: " + sbuf1.toString());
                System.out.println("Q: " + sbuf2.toString());
                System.out.println("N: " + sbuf3.toString());
            }
            System.out.println("Read back the license key and verify");
            SWIGTYPE_p_LIMLIC pLic = liman.lim_create_lic_fromfile(pEnv, szLicenseKeyFile, pnErr);
            if (pnErr[0] != liman.LIM_OK) {
                System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
            }
            StringBuffer sbuf2 = new StringBuffer(1024);
            pnErr[0] = liman.lim_print_lic(pLic, sbuf2);
            if (pnErr[0] != liman.LIM_OK) {
                System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
            }
            System.out.println("Print the license");
            System.out.println(sbuf2.toString());
            System.out.println("Print sha32 base16");
            byte [] sha = new byte [32];
            liman.lim_get_licsha(pLic, sha);
            System.out.println("SHA:" + liman.lim_base16(sha, 32));
            liman.lim_delete_lic(pLic);
        }
        System.out.println("Encode the string 'JAVA_SECRETS' into linux.bmp and save it as linux_new.bmp");
        pnErr[0] = liman.lim_st_encode("../data/linux.bmp", "JAVA_SECRETS", "../data/linux_new.bmp");
        if (pnErr[0] != liman.LIM_OK) {
            System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
        }
        System.out.println("Decode text hidden in linux_new.bmp and display");
        String secret = liman.lim_st_decode("../data/linux_new.bmp", null, pnErr);
        if (pnErr[0] != liman.LIM_OK) {
            System.out.println("Error " + pnErr[0] + ":" + liman.lim_errmsg(pEnv, pnErr[0]));
        }
        else {
            System.out.printf("\nHidden Secret: %s\n\n", secret);
        }
        liman.lim_delete_env(pEnv);
    }
}
