---
-- limutil.lua
-- This is a utility application to perform various LIMAN SDK tasks,
--
--    - generate keypairs
--    - determine hardware and users features (macid,userid,cpuid,etc..)
--    - calculate hash of input data (files or strings)
--    - hide small data in BMP (bitmap) files.
--    - UUID generation
--
-- @remark Derived from apps/c/limgen.c
package.cpath = os.getenv("LIMAN_ROOT") .. "/bin/win32x86/?.dll"

local liman = require 'lualiman'
local defaults = require 'liman_defaults'

---
-- C-sprintf
sprintf = function(fmt, ...)   
    local s=string.format(fmt, ...)
    return s 
end
---
-- C-printf
printf = function(fmt, ...) 
    io.stdout:flush() 
    io.write(string.format(fmt, ...)) 
    io.stdout:flush() 
end 

---
-- Check error 
function checkerr(pEnv,nErr,isExit)
	local isExit = isExit or 0
	if nErr>0 then
		printf("Error %d: %s\n",nErr,liman.lim_errmsg(pEnv,nErr))
    if isExit>0 then
      printf("Exiting (%d)..\n",isExit);
      nErr = liman.lim_delete_env(pEnv)
      os.exit(1)
    end		
  end
end

---
-- Main
local nErr,major,minor,build,rev,sbuf = liman.lim_get_verkey(nil)
printf("version: LIMAN SDK %d.%d.%d %s\n",major,minor,rev,sbuf)

-- create product-license-base
local szProductId="MYLUAPP"
local nKeySize=defaults.DEFAULT_KEYSIZE
local nSeed=1031
nErr = liman.lim_gen_keypair(nKeySize,nSeed,szProductId);
checkerr(pEnv,nErr,0)

local szPublicKeyFile="MYLUAPP/MYLUAPP_public.key"
local szPrivateKeyFile="MYLUAPP/MYLUAPP_private.key"


-- new license env
local nHashSize=defaults.DEFAULT_HASHSIZE
local pEnv,nErr = liman.lim_create_env(nKeySize,nHashSize)
checkerr(pEnv,nErr,0)


--prep encrypted messages from MYLUAPP users (to be sent to you)
nErr = liman.lim_read_public_key(pEnv,szPublicKeyFile); 
checkerr(pEnv,nErr,0)
nErr = liman.lim_write_secretmsg(pEnv,sbuf,"usr_sysinfo.txt");
checkerr(pEnv,nErr,0)

--hostid
nErr,sbuf = liman.lim_get_hostid(nil,0);
checkerr(pEnv,nErr,0)
printf("hostid: %s\n",sbuf)

--uuid
printf("\n")
nErr,sbuf = liman.lim_gen_uuid(pEnv,0,nil) -- seed is time()
printf("uuid: %s\n",sbuf)

if 0>1 then
  -- generate 10 more
  for k=1,10 do
    nErr,sbuf = liman.lim_gen_uuid(pEnv,-1,nil) -- continue with stream  
    checkerr(pEnv,nErr,0)
    --convert to canonical uuid
    local cuuid = liman.lim_canonical_uuid(sbuf)
    checkerr(pEnv,nErr,0)
    printf("uuid:%s <-> c-uuid:%s\n",sbuf,cuuid)
  end
end

-- dispose env
nErr = liman.lim_delete_env(pEnv)
checkerr(0,nErr,0)

