#!/bin/sh
# Generate a new license for TESTAPP product using its designated key-pair
# (c) Baroks Inc.
# $Id$
#
LIMAN_ROOT=../..
PWD=`pwd`
PLATFORM=${PWD##*/}
echo Platform: $PLATFORM

PRODUCT=TESTAPP
if [ "$PRODUCT" = "" ]; then
	echo "Usage: lg_product.sh PRODUCTID [limgen-options]"
	exit 1
fi
LIMGEN=$LIMAN_ROOT/lib/${PLATFORM}/limgen

#Location of public key (modify if needed)
PUB=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/${PRODUCT}_public.key

#Location of private key (modify if needed)
PRIV=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/${PRODUCT}_private.key

#Generate a product key with specified input
#Type limgen -h for help
echo Product: $PRODUCT
echo Private key file: $PRIV
echo Public key file: $PUB
#$LIMGEN --product=$PRODUCT --major=1 --minor=0 -T --privkeyfile=$PRIV  --pubkeyfile=$PUB $1 $2 $3 $4 $5
echo
echo Check command used to generate the license:
echo $LIMGEN --product=$PRODUCT --major=1 --minor=0 -T --privkeyfile=$PRIV  --pubkeyfile=$PUB $1 $2 $3 $4 $5

